function [fval,fjac] = MeFuncCP(x, NfEquiMatch) % return the function value (Dis) and Jacobian at any point 

    % \hat{f(x)}=min(max(f(x),a-x),b-x)=0, \hat{f(x)}=Dis, transform into rootfinding problem 
    % x is arbitrary value of q, find 8 x
    % fval = MeEquiMatch(x); generate error, Not enough input arguments.
    
    fval = NfEquiMatch(x); % return the function value (Dis) at any value of q 

    % how to get fjac with complex function form
    % find derivatives 
    
    n = size(x,1); % return how many numbers x have
    eps = 1d-6; %1e^(-5) 
     
    for i = 1 : n
        xleft = x; 
        xright = x;
        xleft(i) = x(i) - eps/2; % Delta_x/2
        xright(i) = x(i) + eps/2;
        fleftval = NfEquiMatch(xleft);
        frightval = NfEquiMatch(xright);
        fjac(:,i) = (frightval - fleftval)/eps; % for all row, ith column. The slope of Dis 
    end

end

 